﻿/*
 * Erstellt mit SharpDevelop.
 * Benutzer: Talentfrei
 * Datum: 30.06.2010
 * Zeit: 21:26
 * 
 * Sie können diese Vorlage unter Extras > Optionen > Codeerstellung > Standardheader ändern.
 * ...hmm super, ich kanns aber auch lassen...
 */
#region usings


using System;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows;
using System.Windows.Forms;
using System.Xml;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing.Imaging;
using System.Drawing.Drawing2D;
using System.Threading;
using System.IO;

using AForge.Video;
using AForge.Video.DirectShow;
using AForge.Imaging.Filters;
using AForge;
using AForge.Imaging;

using ZedGraph;
#endregion

namespace Spektro_analyzer
{
	public partial class Mainform : Form
	{
		[STAThread]
        static void Main()
        {
            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);
            Application.Run(new Mainform());
        }
		
        private bool camini = false;
        #region Variablen
        string error_s = "";
        bool loock_ctrl = false;
        int startmouse_y = 0;
		int startmouse_x = 0;
		SymbolType sym = SymbolType.None;
		SymbolType sym_M = SymbolType.None;
		private VideoCaptureDevice video1;
		private FilterInfoCollection videosources = null;
		LineItem[] Curves = new LineItem[6];
		private int pic_nr = 0;
		private byte cam = 0;
		byte cam_droped = 0;
		int cam_H = 480;
		int cam_W = 640;
		int cam_fps = 10;
		int cam_fps_in_ms = 40;
		private bool working = false;
		private Point back = Point.Empty;
      	private byte[] map_r = new byte[256];
      	private byte[] map_g = new byte[256];
      	private byte[] map_b = new byte[256];
      	//menü
      	public bool set_messline = false;
      	public bool IRfarbverlauf = true;
      	bool graph_rainbow = false;
      	bool graph_label = false;
      	bool graph_merke = false;
      	bool math_active = false;
      	Messline ML = new Messline();
      	public Messline Messline {
		    get { return ML; }
		    set { ML = value; }
		}
      	#endregion
      	
		//##################################################################
		
		#region Hauptform
		Mainform()
		{
			
			InitializeComponent();
			draw_ironbow_palette();
			ML.Mainform = this;
			tab_funktionen.TabPages.Remove(tabPage_pseudo);
			tab_funktionen.TabPages.Remove(tabPage_contrast);
			tab_funktionen.TabPages.Remove(tabPage_channel);
			tab_funktionen.TabPages.Remove(tabPage_EcolorF);
			tab_funktionen.TabPages.Remove(tabPage_colorF);
			tab_funktionen.TabPages.Remove(tabPage_minmax);
//			tab_funktionen.TabPages.Remove();
		}
		void MainformLoad(object sender, EventArgs e)
		{	
			TCB_gra_modus.SelectedIndex = 0;
			TCB_gra_symbol.SelectedIndex = 0;
			TCB_merk_symbol.SelectedIndex = 0;
			TCB_merk_channel.SelectedIndex = 0;
			CB_cam_auflösung.SelectedIndex = 3;
			combo_palette.SelectedIndex = 3;
			TCB_math_art.SelectedIndex = 0;
			TCB_math_op1.SelectedIndex = 0;
			TCB_math_op2.SelectedIndex = 0;
			TBtn_cam_suchenClick(null,null);
			pic_backbox.Image = new Bitmap("test.jpg");
			pic_backfilter.Image = new Bitmap("test.jpg");
			timer_off.Enabled = true;
			if (camini)
			{
				TBtn_cam_startClick(null,null);
			}
			Graph_setup();
			try {
				xml_lesen();
			} catch (Exception err) {
				MessageBox.Show(err.Message,"Fehler beim laden der Setup.xml");
			}
			
		}
		void Graph_setup()
		{
			GraphPane GP = zedGraphControl1.GraphPane;
			if (Curves[0] == null) {
				PointPairList list = new PointPairList();
				int messlengh = pic_backbox.Image.Width-(int)ML.num_messline_start.Value-(int)ML.num_messline_end.Value;
				for (int i=0;i < messlengh;i++)
				{
					list.Add( i, 0 );
				}
				Curves[0] = GP.AddCurve( "Messung",list, txt_gra_linecolor.BackColor, SymbolType.None );
//				for (int i=1;i < 6;i++)
//				{
//					Curves[i] = GP.AddCurve( "LEER",list, Color.White, SymbolType.None );
//					Curves[i].IsVisible = false;
//					Curves[i].Label.IsVisible = false;
//				}
				Tbtn_gra_resetzoomClick(null,null);
			}
			
			GP.Title.Text = txt_gra_titel.Text;
			GP.XAxis.Title.Text = "Wellenlänge in nm";
			GP.YAxis.Title.Text = "Intensität in Pixel";
			GP.XAxis.MajorGrid.IsVisible = true;
			GP.YAxis.MajorGrid.IsVisible = true;
			GP.XAxis.MajorGrid.Color = Color.DimGray;
			GP.YAxis.MajorGrid.Color = Color.DimGray;
			GP.XAxis.MajorGrid.IsZeroLine = false;
			GP.YAxis.MajorGrid.IsZeroLine = false;
			GP.Chart.Fill = new Fill( Color.Black);
		}
		void MainformFormClosing(object sender, FormClosingEventArgs e)
		{
			xml_erstellen();
			Tbtn_cam_stopClick(null,null);
		}
		
		void MainformDragDrop(object sender, DragEventArgs e)
		{
			loock_ctrl = true;
			try 
			{	
				if (e.Data.GetDataPresent (DataFormats.FileDrop))
				{	//versuche die gedropte datei als bild zu laden
					Tbtn_cam_stopClick(null,null);
					string[] filepath = (string[]) e.Data.GetData (DataFormats.FileDrop);
					System.Drawing.Image image = System.Drawing.Image.FromFile (filepath[0]);
					Bitmap img = new Bitmap(image);
					img.SetResolution(96f,96f);
					img = img.Clone(new Rectangle(0, 0, img.Width, img.Height), PixelFormat.Format24bppRgb);
					pic_backbox.Image = img;
					ML.Picbox1.Image = img;
					timer_off.Enabled = true;
					pic_nr = 0;
					Tbtn_gra_resetzoomClick(null,null);
					return;
				} 
			} catch (Exception) {}
			try 
			{	
				if (e.Data.GetDataPresent (DataFormats.FileDrop))
				{	//versuche die gedropte datei als kurve zu laden
					string[] filepath = (string[]) e.Data.GetData (DataFormats.FileDrop);
					StreamReader txt = File.OpenText(filepath[0]);
					string[] inhalt = txt.ReadToEnd().Split('\r');
					//label
					string[] split_s = inhalt[0].Split('=');
					txt_merk_name.Text = split_s[1];
					//channel
					split_s = inhalt[1].Split('=');
					int read_i = 0;
					int.TryParse(split_s[1],out read_i);
					TCB_merk_channel.SelectedIndex = read_i-1;
					//symbol
					split_s = inhalt[2].Split('=');
					read_i = 0;
					int.TryParse(split_s[1],out read_i);
					TCB_merk_symbol.SelectedIndex = read_i;
					//color
					byte R,G,B = 0;
					split_s = inhalt[3].Split('=');
					string[] col_s = split_s[1].Split('#');
					byte.TryParse(col_s[0],out R);
					byte.TryParse(col_s[1],out G);
					byte.TryParse(col_s[2],out B);
					txt_merk_linecolor.BackColor = Color.FromArgb(255,R,G,B);
					//data
					Application.DoEvents();
					PointPairList list = new PointPairList();
					double x = 0;
					double y = 0;
					for (int i=4;i < inhalt.Length -1;i++)
					{
						 split_s = inhalt[i].Split('	');
						 double.TryParse(split_s[0],out x);
						 double.TryParse(split_s[1],out y);
						 list.Add( x, y);
					}
					if (Curves[TCB_merk_channel.SelectedIndex+1] == null) {
						Curves[TCB_merk_channel.SelectedIndex+1] = zedGraphControl1.GraphPane.AddCurve( txt_merk_name.Text,list, txt_merk_linecolor.BackColor, sym_M );
					} else {
						PointPairList PPL_M = zedGraphControl1.GraphPane.CurveList[TCB_merk_channel.SelectedIndex+1].Points as PointPairList;
						Curves[TCB_merk_channel.SelectedIndex+1].Color = txt_merk_linecolor.BackColor;
						Curves[TCB_merk_channel.SelectedIndex+1].Label.Text = txt_merk_name.Text;
						Curves[TCB_merk_channel.SelectedIndex+1].Label.IsVisible = true;
						Curves[TCB_merk_channel.SelectedIndex+1].IsVisible = true;
						switch (TCB_merk_symbol.SelectedIndex) {
							case 1:
								Curves[TCB_merk_channel.SelectedIndex+1].Symbol.Type = SymbolType.Circle;
								break;
							case 2:
								Curves[TCB_merk_channel.SelectedIndex+1].Symbol.Type = SymbolType.Diamond;
								break;
							case 3:
								Curves[TCB_merk_channel.SelectedIndex+1].Symbol.Type = SymbolType.Square;
								break;
							case 4:
								Curves[TCB_merk_channel.SelectedIndex+1].Symbol.Type = SymbolType.Triangle;
								break;
						}
						Curves[TCB_merk_channel.SelectedIndex+1].Symbol.Fill = new Fill( Color.White );
						PPL_M.Clear();
						PPL_M.Add(list);
					}
					txt.Close();
				} 
			} catch (Exception) {}
			loock_ctrl = false;
		}
		void MainformDragOver(object sender, DragEventArgs e)
		{
			if (e.Data.GetDataPresent(DataFormats.FileDrop))
			{	
				if ((e.AllowedEffect & DragDropEffects.Move) != 0)
				{
					e.Effect = DragDropEffects.Move;
				}
			}	
		}
		
		void MainformKeyDown(object sender, KeyEventArgs e)
		{	//tastaturwerte abfragen
			if ((working == true)||(e.KeyData == Keys.Tab))
			{
				return;
			}
			working = true;
			label_key.Text = e.KeyData.ToString();
			if (e.KeyData == Keys.Escape) 
			{
				working = false;
				return;
			}
			working = false;
		}
		void MainformMouseDown(object sender, MouseEventArgs e)
		{
			startmouse_x = e.X;
        	startmouse_y = e.Y;
//        	if (e.Button == MouseButtons.Left) {
//        		mouse_left = true;
//        	} else {
//        		mouse_left = false;
//        	}
		}
		void Label_setupMouseDown(object sender, MouseEventArgs e)
		{
			label_setup.BackColor = Color.RoyalBlue;
			startmouse_x = e.X;
			startmouse_y = e.Y;
		}
		void Label_setupMouseMove(object sender, MouseEventArgs e)
		{
			if (e.Button == MouseButtons.Left) 
			{
				panel_filter.Top += e.Y - startmouse_y;
				panel_filter.Left += e.X - startmouse_x;
			}
		}
		void Label_setupMouseUp(object sender, MouseEventArgs e)
		{
			label_setup.BackColor = Color.LightSteelBlue;
		}	
		
		void xml_erstellen()
		{
			XmlTextWriter xml = new XmlTextWriter("setup.xml", System.Text.Encoding.UTF8);
			xml.Formatting = Formatting.Indented;
			xml.WriteStartDocument(false);
			xml.WriteStartElement("Setup");
				xml.WriteElementString("main", ML.check_write_setupxml.Checked.ToString());
				xml.WriteElementString("bool_0", tool_graph.Visible.ToString());
				xml.WriteElementString("bool_1", tool_Merker.Visible.ToString());
				xml.WriteElementString("bool_2", tool_camera.Visible.ToString());
				xml.WriteElementString("bool_3", tool_math.Visible.ToString());
				xml.WriteElementString("bool_4", ML.check_IR_Blue.Checked.ToString());
				xml.WriteElementString("bool_5", ML.check_sin_stop255.Checked.ToString());
				xml.WriteElementString("bool_6", ML.check_graph_withIR.Checked.ToString());
				xml.WriteElementString("int_0", ML.scroll_Messline.Value.ToString());
				xml.WriteElementString("decimal_0", ML.num_messline_start.Value.ToString());
				xml.WriteElementString("decimal_1", ML.num_messline_end.Value.ToString());
				xml.WriteElementString("decimal_2", ML.num_graph_x1.Value.ToString());
				xml.WriteElementString("decimal_3", ML.num_graph_x2.Value.ToString());
				xml.WriteElementString("decimal_4", ML.num_graph_y1.Value.ToString());
				xml.WriteElementString("decimal_5", ML.num_graph_y2.Value.ToString());
				xml.WriteElementString("decimal_6", ML.num_skala_Blue_iroffset.Value.ToString());
				xml.WriteElementString("decimal_7", ML.num_skala_offset.Value.ToString());
				xml.WriteElementString("decimal_8", ML.num_skala_span.Value.ToString());
				xml.WriteElementString("decimal_9", ML.num_sin_nm.Value.ToString());
				xml.WriteElementString("decimal_10", ML.num_sin_offX.Value.ToString());
				xml.WriteElementString("decimal_11", ML.num_sin_offY.Value.ToString());
				xml.WriteElementString("decimal_12", ML.num_sin_pixel.Value.ToString());
			xml.WriteEndElement();
			xml.Flush();
			xml.Close();
		}
		void xml_lesen()
		{
			XmlDocument doc = new XmlDocument();
			if (File.Exists("setup.xml")) 
			{
				doc.Load("setup.xml");
				bool r_bool = false;
				int r_int = 0;
				decimal r_dec = 0;
				string read_s = "";
				if (doc.DocumentElement["main"] != null)
				{
					read_s = doc.DocumentElement["main"].InnerText;
					bool.TryParse(read_s,out r_bool);
					ML.check_write_setupxml.Checked = r_bool;
					if (!r_bool) {
						return;
					}
				}
				for (int i=0;i < 14 ;i++)
				{
					if (doc.DocumentElement["bool_"+i.ToString()] != null)
					{
						read_s = doc.DocumentElement["bool_"+i.ToString()].InnerText;
						bool.TryParse(read_s,out r_bool);
						switch (i) {
							case 0:
								if (!r_bool) { Tbtn_main_graphClick(null,null); } break;
							case 1:
								if (!r_bool) { Tbtn_main_merkerClick(null,null); } break;
							case 2:
								if (!r_bool) { Tbtn_main_camClick(null,null); } break;
							case 3:
								if (!r_bool) { Tbtn_main_mathClick(null,null); } break;
							case 4:
								ML.check_IR_Blue.Checked = r_bool;
								break;
							case 5:
								ML.check_sin_stop255.Checked = r_bool;
								break;
							case 6:
								ML.check_graph_withIR.Checked = r_bool;
								break;
						}
					}
					if (doc.DocumentElement["int_"+i.ToString()] != null)
					{
						read_s = doc.DocumentElement["int_"+i.ToString()].InnerText;
						int.TryParse(read_s,out r_int);
						switch (i) {
							case 0:
								ML.scroll_Messline.Value = r_int;
								break;
						}
					}
					if (doc.DocumentElement["decimal_"+i.ToString()] != null)
					{
						read_s = doc.DocumentElement["decimal_"+i.ToString()].InnerText;
						decimal.TryParse(read_s,out r_dec);
						switch (i) {
							case 0:
								ML.num_messline_start.Value = r_dec; break;
							case 1:
								ML.num_messline_end.Value = r_dec; break;
							case 2:
								ML.num_graph_x1.Value = r_dec; break;
							case 3:
								ML.num_graph_x2.Value = r_dec; break;
							case 4:
								ML.num_graph_y1.Value = r_dec; break;
							case 5:
								ML.num_graph_y2.Value = r_dec; break;
							case 6:
								ML.num_skala_Blue_iroffset.Value = r_dec; break;
							case 7:
								ML.num_skala_offset.Value = r_dec; break;
							case 8:
								ML.num_skala_span.Value = r_dec; break;
							case 9:
								ML.num_sin_nm.Value = r_dec; break;
							case 10:
								ML.num_sin_offX.Value = r_dec; break;
							case 11:
								ML.num_sin_offY.Value = r_dec; break;
							case 12:
								ML.num_sin_pixel.Value = r_dec; break;
						}
					}
				}
			}
		}
		#endregion
		
		#region Menübars
		//mainmenu
		void Tbtn_main_exitClick(object sender, EventArgs e)
		{
			Application.Exit();
		}
		void Tbtn_main_showsourceboxClick(object sender, EventArgs e)
		{
			if (tbtn_main_showsourcebox.ForeColor == Color.Red) {
				tbtn_main_showsourcebox.ForeColor = Color.Lime;
				pic_backbox.Visible = true;
			} else {
				pic_backbox.Visible = false;
				tbtn_main_showsourcebox.ForeColor = Color.Red;
			}
		}
		void Tbtn_main_showfilterboxClick(object sender, EventArgs e)
		{
			if (tbtn_main_showfilterbox.ForeColor == Color.Red) {
				tbtn_main_showfilterbox.ForeColor = Color.Lime;
				pic_backfilter.Visible = true;
			} else {
				pic_backfilter.Visible = false;
				tbtn_main_showfilterbox.ForeColor = Color.Red;
			}
		}
		void Tbtn_main_savesourceClick(object sender, EventArgs e)
		{
			try 
			{	
				if (!(pic_backbox.Image == null))
				{
					Picform seond = new Picform();
					seond.Show();
					seond.pictureBox1.Image = (Bitmap)pic_backbox.Image.Clone();
					seond.text_pfad.Text = "Quelle_" + pic_nr;
					pic_nr += 1;
				}
			} catch (Exception err) 
			{
				timer_off.Enabled = false;
				info_err.Visible = true;
        		info_err.Text = "Fehler in (Save JPG):"+Environment.NewLine+err.Message;
			}
		}
		void Tbtn_main_savegraphClick(object sender, EventArgs e)
		{
			try 
			{	
				if (!(pic_backbox.Image == null))
				{
					Picform seond = new Picform();
					seond.Show();
					seond.pictureBox1.Image = zedGraphControl1.GraphPane.GetImage();
					seond.text_pfad.Text = txt_main_picname.Text+ "_" + pic_nr;
					pic_nr += 1;
				}
			} catch (Exception err) 
			{
				timer_off.Enabled = false;
				info_err.Visible = true;
        		info_err.Text = "Fehler in (Save JPG):"+Environment.NewLine+err.Message;
			}
		}
		void Tbtn_main_graphinclipClick(object sender, EventArgs e)
		{
			Clipboard.SetImage(zedGraphControl1.GraphPane.GetImage());
		}
		void Tbtn_main_setupClick(object sender, EventArgs e)
		{
			if (tbtn_main_setup.ForeColor == Color.Black) {
				tbtn_main_setup.ForeColor = Color.Gold;
				ML.Show();
				set_messline = true;
			} else {
				ML.Hide();
				set_messline = false;
				tbtn_main_setup.ForeColor = Color.Black;
			}
		}
		void Tbtn_main_graphClick(object sender, EventArgs e)
		{
			if (tbtn_main_graph.ForeColor == Color.Black) {
				tbtn_main_graph.ForeColor = Color.LimeGreen;
				tool_graph.Visible = true;
			} else {
				tool_graph.Visible = false;
				tbtn_main_graph.ForeColor = Color.Black;
			}
		}
		void Tbtn_main_merkerClick(object sender, EventArgs e)
		{
			if (tbtn_main_merker.ForeColor == Color.Black) {
				tbtn_main_merker.ForeColor = Color.LimeGreen;
				tool_Merker.Visible = true;
			} else {
				tool_Merker.Visible = false;
				tbtn_main_merker.ForeColor = Color.Black;
			}
		}
		void Tbtn_main_camClick(object sender, EventArgs e)
		{
			if (tbtn_main_cam.ForeColor == Color.Black) {
				tbtn_main_cam.ForeColor = Color.LimeGreen;
				tool_camera.Visible = true;
			} else {
				tool_camera.Visible = false;
				tbtn_main_cam.ForeColor = Color.Black;
			}
		}
		void Tbtn_main_filterClick(object sender, EventArgs e)
		{
			if (tbtn_main_filter.ForeColor == Color.Black) {
				tbtn_main_filter.ForeColor = Color.LimeGreen;
				panel_filter.Visible = true;
				panel_filter.Top = 12;
				panel_filter.Left = 12;
			} else {
				panel_filter.Visible = false;
				tbtn_main_filter.ForeColor = Color.Black;
			}
		}
		void Txt_main_picnameTextChanged(object sender, EventArgs e)
		{
			pic_nr = 0;
		}
		void Tbtn_main_mathClick(object sender, EventArgs e)
		{
			if (tbtn_main_math.ForeColor == Color.Black) {
				tbtn_main_math.ForeColor = Color.LimeGreen;
				tool_math.Visible = true;
			} else {
				tool_math.Visible = false;
				tbtn_main_math.ForeColor = Color.Black;
			}
		}
		//graph
		void Tbtn_gra_rainbowClick(object sender, EventArgs e)
		{
			if (tbtn_gra_rainbow.ForeColor == Color.Black) {
				tbtn_gra_rainbow.ForeColor = Color.LimeGreen;
				graph_rainbow = true;
			} else {
				graph_rainbow = false;
				tbtn_gra_rainbow.ForeColor = Color.Black;
			}
		}
		void Tbtn_gra_showlabelClick(object sender, EventArgs e)
		{
			if (tbtn_gra_showlabel.ForeColor == Color.Black) {
				tbtn_gra_showlabel.ForeColor = Color.LimeGreen;
				graph_label = true;
			} else {
				graph_label = false;
				tbtn_gra_showlabel.ForeColor = Color.Black;
			}
		}
		void Tbtn_gra_resetzoomClick(object sender, EventArgs e)
		{
			GraphPane GP = zedGraphControl1.GraphPane;
			GP.XAxis.Scale.Min = (int)ML.num_graph_x1.Value;
			GP.YAxis.Scale.Min = (int)ML.num_graph_y1.Value;
			GP.XAxis.Scale.Max = (int)ML.num_graph_x2.Value;
			GP.YAxis.Scale.Max = (int)ML.num_graph_y2.Value;
			zedGraphControl1.AxisChange();
			zedGraphControl1.Invalidate();
		}
		void Txt_gra_titelKeyDown(object sender, KeyEventArgs e)
		{
			if (e.KeyCode == Keys.Enter) {
				Graph_setup();
			}
		}
		void Txt_gra_linecolorClick(object sender, EventArgs e)
		{
			if ( colorDialog.ShowDialog() == DialogResult.OK )
			{ 
			 	txt_gra_linecolor.BackColor = colorDialog.Color;
			}
			zedGraphControl1.Focus();
		}
		void TCB_gra_symbolSelectedIndexChanged(object sender, EventArgs e)
		{
			switch (TCB_gra_symbol.SelectedIndex) {
				case 0:
					sym = SymbolType.None;
					break;
				case 1:
					sym = SymbolType.Circle;
					break;
				case 2:
					sym = SymbolType.Diamond;
					break;
				case 3:
					sym = SymbolType.Square;
					break;
				case 4:
					sym = SymbolType.Triangle;
					break;
			}
		}
		//Merker
		void Tbtn_merk_LinieMerkenClick(object sender, EventArgs e)
		{
			if (Tbtn_merk_LinieMerken.ForeColor == Color.Black) {
				Tbtn_merk_LinieMerken.ForeColor = Color.Lime;
				graph_merke = true;
			} else {
				graph_merke = false;
				Tbtn_merk_LinieMerken.ForeColor = Color.Black;
			}
		}
		void Txt_merk_linecolorClick(object sender, EventArgs e)
		{
			if ( colorDialog.ShowDialog() == DialogResult.OK )
			{ 
			 	txt_merk_linecolor.BackColor = colorDialog.Color;
			 	if (Curves[TCB_merk_channel.SelectedIndex+1] != null) {
					Curves[TCB_merk_channel.SelectedIndex+1].Color = colorDialog.Color;
				}
			}
			zedGraphControl1.Focus();
		}
		void TCB_merk_channelSelectedIndexChanged(object sender, EventArgs e)
		{
			if (loock_ctrl) {
				return;
			}
			if (Curves[TCB_merk_channel.SelectedIndex+1] != null) {
				txt_merk_linecolor.BackColor = Curves[TCB_merk_channel.SelectedIndex+1].Color;
				txt_merk_name.Text = Curves[TCB_merk_channel.SelectedIndex+1].Label.Text;
				int index = 0;
				switch (Curves[TCB_merk_channel.SelectedIndex+1].Symbol.Type) {
					case SymbolType.Circle:
						index = 1;
						break;
					case SymbolType.Diamond:
						index = 2;
						break;
					case SymbolType.Square:
						index = 3;
						break;
					case SymbolType.Triangle:
						index = 4;
						break;
				}
				TCB_merk_symbol.SelectedIndex = index;
			} else {
				txt_merk_name.Text = "Merker "+(TCB_merk_channel.SelectedIndex+1).ToString();
			}
		}
		void TCB_merk_symbolSelectedIndexChanged(object sender, EventArgs e)
		{
			switch (TCB_merk_symbol.SelectedIndex) {
				case 0:
					sym_M = SymbolType.None;
					break;
				case 1:
					sym_M = SymbolType.Circle;
					break;
				case 2:
					sym_M = SymbolType.Diamond;
					break;
				case 3:
					sym_M = SymbolType.Square;
					break;
				case 4:
					sym_M = SymbolType.Triangle;
					break;
			}
			if (Curves[TCB_merk_channel.SelectedIndex+1] != null) {
				Curves[TCB_merk_channel.SelectedIndex+1].Symbol.Type = sym_M;
				Curves[TCB_merk_channel.SelectedIndex+1].Symbol.Fill = new Fill( Color.White );
			}
		}
		void Txt_merk_nameKeyDown(object sender, KeyEventArgs e)
		{
			if (e.KeyCode == Keys.Enter) {
				if (Curves[TCB_merk_channel.SelectedIndex+1] != null) {
					Curves[TCB_merk_channel.SelectedIndex+1].Label.Text = txt_merk_name.Text;
				}
			}
		}
		void Tbtn_merk_remove_oneClick(object sender, EventArgs e)
		{
			DialogResult result;
			result = MessageBox.Show("Soll "+txt_merk_name.Text+" entfernt werden?","Löschen...",MessageBoxButtons.YesNo);
			if (result != DialogResult.Yes) 
			{
				return;
			}
			if (Curves[TCB_merk_channel.SelectedIndex+1] != null) {
				Curves[TCB_merk_channel.SelectedIndex+1].Label.IsVisible = false;
				Curves[TCB_merk_channel.SelectedIndex+1].Clear();
				Curves[TCB_merk_channel.SelectedIndex+1] = null;
			}
			zedGraphControl1.AxisChange();
			zedGraphControl1.Invalidate();
		}
		void Tbtn_merk_del_oneClick(object sender, EventArgs e)
		{
			if (Curves[TCB_merk_channel.SelectedIndex+1] != null) {
				Curves[TCB_merk_channel.SelectedIndex+1].IsVisible = false;
				Curves[TCB_merk_channel.SelectedIndex+1].Label.IsVisible = false;
			}
			zedGraphControl1.AxisChange();
			zedGraphControl1.Invalidate();
		}
		void Tbtn_merk_del_allClick(object sender, EventArgs e)
		{
			for (int i=1;i < 6;i++)
			{
				if (Curves[i] != null) {
					Curves[i].IsVisible = false;
					Curves[i].Label.IsVisible = false;
				}
			}
			zedGraphControl1.AxisChange();
			zedGraphControl1.Invalidate();
		}
		void Tbtn_merk_del_noneClick(object sender, EventArgs e)
		{
			for (int i=1;i < 6;i++)
			{
				if (Curves[i] != null) {
					if (Curves[i].Label.Text != "LEER".ToString()) {
						Curves[i].IsVisible = true;
						Curves[i].Label.IsVisible = true;
					}
				}
			}
			zedGraphControl1.AxisChange();
			zedGraphControl1.Invalidate();
		}
		void Tbtn_merk_save_selectedClick(object sender, EventArgs e)
		{
			if (Curves[TCB_merk_channel.SelectedIndex+1] == null) {
				MessageBox.Show("Im Channel ("+(TCB_merk_channel.SelectedIndex+1).ToString()+") befindet sich keine Kurve.","Keine Kurve zum speichern...");
        		return;
    		}
			if (DialogResult.OK == saveFileDialog1.ShowDialog()) {
				StreamWriter txt = File.CreateText(saveFileDialog1.FileName);
				PointPairList PPL = zedGraphControl1.GraphPane.CurveList[0].Points as PointPairList;
				txt.WriteLine( "Label="+txt_merk_name.Text );
				txt.WriteLine( "Channel="+(TCB_merk_channel.SelectedIndex+1).ToString() );
				txt.WriteLine( "Symbol="+TCB_merk_symbol.SelectedIndex.ToString() );
				txt.WriteLine( "Color="+txt_merk_linecolor.BackColor.R.ToString()+"#"
				             	+txt_merk_linecolor.BackColor.G.ToString()+"#"
				            	+txt_merk_linecolor.BackColor.B.ToString());
				for (int i=0;i < PPL.Count ;i++)
				{
					txt.WriteLine( PPL[i].X.ToString() + "	" + PPL[i].Y.ToString() );
				}
				txt.Write(PPL[PPL.Count-1].X.ToString() + "	" + PPL[PPL.Count-1].Y.ToString());
				txt.Close();
			}
		}
		void Tbtn_merk_load_selectedClick(object sender, EventArgs e)
		{
			
			try {
				if (DialogResult.OK != openFileDialog1.ShowDialog()) {
					return;
				}
				StreamReader txt = File.OpenText(openFileDialog1.FileName);
				string[] inhalt = txt.ReadToEnd().Split('\r');
				//label
				string[] split_s = inhalt[0].Split('=');
				txt_merk_name.Text = split_s[1];
				//symbol
				split_s = inhalt[2].Split('=');
				int read_i = 0;
				int.TryParse(split_s[1],out read_i);
				TCB_merk_symbol.SelectedIndex = read_i;
				//color
				byte R,G,B = 0;
				split_s = inhalt[3].Split('=');
				string[] col_s = split_s[1].Split('#');
				byte.TryParse(col_s[0],out R);
				byte.TryParse(col_s[1],out G);
				byte.TryParse(col_s[2],out B);
				txt_merk_linecolor.BackColor = Color.FromArgb(255,R,G,B);
				//data
				Application.DoEvents();
				PointPairList list = new PointPairList();
				double x = 0;
				double y = 0;
				for (int i=4;i < inhalt.Length -1;i++)
				{
					 split_s = inhalt[i].Split('	');
					 double.TryParse(split_s[0],out x);
					 double.TryParse(split_s[1],out y);
					 list.Add( x, y);
				}
				if (Curves[TCB_merk_channel.SelectedIndex+1] == null) {
					Curves[TCB_merk_channel.SelectedIndex+1] = zedGraphControl1.GraphPane.AddCurve( txt_merk_name.Text,list, txt_merk_linecolor.BackColor, sym_M );
				} else {
					PointPairList PPL_M = zedGraphControl1.GraphPane.CurveList[TCB_merk_channel.SelectedIndex+1].Points as PointPairList;
					Curves[TCB_merk_channel.SelectedIndex+1].Color = txt_merk_linecolor.BackColor;
					Curves[TCB_merk_channel.SelectedIndex+1].Label.Text = txt_merk_name.Text;
					Curves[TCB_merk_channel.SelectedIndex+1].Label.IsVisible = true;
					Curves[TCB_merk_channel.SelectedIndex+1].IsVisible = true;
					switch (TCB_merk_symbol.SelectedIndex) {
						case 1:
							Curves[TCB_merk_channel.SelectedIndex+1].Symbol.Type = SymbolType.Circle;
							break;
						case 2:
							Curves[TCB_merk_channel.SelectedIndex+1].Symbol.Type = SymbolType.Diamond;
							break;
						case 3:
							Curves[TCB_merk_channel.SelectedIndex+1].Symbol.Type = SymbolType.Square;
							break;
						case 4:
							Curves[TCB_merk_channel.SelectedIndex+1].Symbol.Type = SymbolType.Triangle;
							break;
					}
					Curves[TCB_merk_channel.SelectedIndex+1].Symbol.Fill = new Fill( Color.White );
					PPL_M.Clear();
					PPL_M.Add(list);
				}
				txt.Close();
			} catch (Exception err) {
				MessageBox.Show(err.Message,"Fehler beim laden der Kurven Datei");
			}
		}
		//Math
		void Tbtn_math_activeClick(object sender, EventArgs e)
		{
			if (tbtn_math_active.ForeColor == Color.Black) {
				tbtn_math_active.ForeColor = Color.LimeGreen;
				math_active = true;
			} else {
				math_active = false;
				tbtn_math_active.ForeColor = Color.Black;
			}
		}
		//cam
		void TBtn_cam_suchenClick(object sender, EventArgs e)
		{
			CB_cam_devices.Items.Clear();
        	cam_droped = 0;
        	//video_combobox mit neuem Inhalt füllen
        	videosources = new FilterInfoCollection(FilterCategory.VideoInputDevice);
            if (videosources.Count != 0)
            {
            	CB_cam_devices.Items.Add("Keine Kamera");
            	foreach (FilterInfo videosource in videosources)
                {
                	cam_droped++;
                    CB_cam_devices.Items.Add("("+cam_droped+") "+videosource.Name);
                }
                CB_cam_devices.ForeColor = Color.FromArgb(0,180,180,0);
                CB_cam_devices.SelectedIndex = 1;            
            }
            else
            {
                CB_cam_devices.Items.Add("Keine Kamera gefunden");
                CB_cam_devices.ForeColor = Color.FromArgb(0,255,0,0);
                CB_cam_devices.SelectedIndex = 0;
            }
            TBtn_cam_suchen.Text = "Suche Kameras ("+videosources.Count+")";
		}
		void TBtn_cam_startClick(object sender, EventArgs e)
		{
			working = false;
        	if ((CB_cam_devices.SelectedIndex > 0) && (video1 == null))
            {	//videoquelle starten
        		timer_off.Enabled = false;
                video1 = new VideoCaptureDevice(videosources[CB_cam_devices.SelectedIndex-1].MonikerString);
            	video1.NewFrame += new NewFrameEventHandler(video_NewFrame);
                video1.DesiredFrameRate = cam_fps;
                timer_on.Interval = cam_fps_in_ms;
                video1.DesiredFrameSize = new Size(cam_W, cam_H);
                video1.Start();
                pic_nr = 0;
                cam_droped = 0;
                timer_on.Enabled = true;
                if (video1.IsRunning == true) 
                {
                	CB_cam_devices.ForeColor = Color.FromArgb(0,0,180,0);
                }
            }
		}
		void Tbtn_cam_stopClick(object sender, EventArgs e)
		{
			if (!(video1 == null))
                if (video1.IsRunning)
                {
                    video1.SignalToStop();
                    video1 = null;
                }
			timer_on.Enabled = false;
			timer_off.Enabled = true;
            CB_cam_devices.ForeColor = Color.FromArgb(0,255,0,0);
            working = false;
		}
		void CB_cam_auflösungSelectedIndexChanged(object sender, EventArgs e)
		{
			switch (CB_cam_auflösung.SelectedIndex) 
			{
				case 1:
					Txt_cam_breite.Text = "320";
					Txt_cam_höhe.Text = "240";
					break;
				case 2:
					Txt_cam_breite.Text = "352";
					Txt_cam_höhe.Text = "288";
					Txt_cam_fps.Text = "30";
					break;
				case 3:
					Txt_cam_breite.Text = "640";
					Txt_cam_höhe.Text = "480";
					break;
				case 4:
					Txt_cam_breite.Text = "800";
					Txt_cam_höhe.Text = "600";
					break;
				case 5:
					Txt_cam_breite.Text = "1024";
					Txt_cam_höhe.Text = "768";
					break;
				case 6:
					Txt_cam_breite.Text = "1280";
					Txt_cam_höhe.Text = "1024";
					break;
			}
		}
		void Txt_cam_breiteTextChanged(object sender, EventArgs e)
		{
			cam_W = 0;
			int.TryParse(Txt_cam_breite.Text, out cam_W);
			if (cam_W > 0)
			{
				Txt_cam_breite.BackColor = Color.White;
			}
			else
			{
				Txt_cam_breite.BackColor = Color.Red;
			}
		}
		void Txt_cam_höheTextChanged(object sender, EventArgs e)
		{
			cam_H = 0;
			int.TryParse(Txt_cam_höhe.Text, out cam_H);
			if (cam_H > 0)
			{
				Txt_cam_höhe.BackColor = Color.White;
			}
			else
			{
				Txt_cam_höhe.BackColor = Color.Red;
			}
		}
		void Txt_cam_fpsTextChanged(object sender, EventArgs e)
		{
			cam_fps = 0;
			int.TryParse(Txt_cam_fps.Text, out cam_fps);
			if (cam_fps > 0)
			{
				Txt_cam_fps.BackColor = Color.White;
				Txt_cam_fps_ms.Text = ((int)Math.Round(1000/(float)cam_fps)).ToString();
			}
			else
			{
				Txt_cam_fps.BackColor = Color.Red;
			}
		}
		void Txt_cam_fps_msTextChanged(object sender, EventArgs e)
		{
			cam_fps_in_ms = 0;
			int.TryParse(Txt_cam_fps_ms.Text, out cam_fps_in_ms);
			if (cam_fps_in_ms > 0)
			{
				Txt_cam_fps_ms.BackColor = Color.White;
			}
			else
			{
				Txt_cam_fps_ms.BackColor = Color.Red;
			}
		}
		#endregion
		
		#region Setup
		//#####################################################
		//+++++++++++++++++++++++++++++++
		//Filter 1
		void Check_minmaxCheckedChanged(object sender, EventArgs e)
		{
			if (check_minmax.Checked) 
			{
				tab_funktionen.TabPages.Add(tabPage_minmax);
			} else
			{
				tab_funktionen.TabPages.Remove(tabPage_minmax);
			}
		}
		
		void Scroll_contrastScroll(object sender, ScrollEventArgs e)
		{
			label_contrast.Text = ((double)scroll_contrast.Value / 1000).ToString();
		}
		void Scroll_helligkeitScroll(object sender, ScrollEventArgs e)
		{
			label_helligkeit.Text = ((double)scroll_helligkeit.Value / 1000).ToString();
		}
		void Btn_contrast_resetClick(object sender, EventArgs e)
		{
			scroll_contrast.Value = 1000;
			label_contrast.Text = "1";
			scroll_helligkeit.Value = 0;
			label_helligkeit.Text = "0";
		}
		void Check_contrastCheckedChanged(object sender, EventArgs e)
		{
			if (check_contrast.Checked) 
			{
				tab_funktionen.TabPages.Add(tabPage_contrast);
			} else
			{
				tab_funktionen.TabPages.Remove(tabPage_contrast);
			}
		}
		//+++++++++++++++++++++++++++++++
		//filter 2
		void Check_colorFCheckedChanged(object sender, EventArgs e)
		{
			if (check_colorF.Checked) 
			{
				tab_funktionen.TabPages.Add(tabPage_colorF);
			} else
			{
				tab_funktionen.TabPages.Remove(tabPage_colorF);
			}
		}
		void Check_channelFCheckedChanged(object sender, EventArgs e)
		{
			if (check_channelF.Checked) 
			{
				tab_funktionen.TabPages.Add(tabPage_channel);
			} else
			{
				tab_funktionen.TabPages.Remove(tabPage_channel);
			}
		}
		void Check_euclideancolorFCheckedChanged(object sender, EventArgs e)
		{
			if (check_euclideancolorF.Checked) 
			{
				tab_funktionen.TabPages.Add(tabPage_EcolorF);
			} else
			{
				tab_funktionen.TabPages.Remove(tabPage_EcolorF);
			}
		}
		
		//+++++++++++++++++++++++++++++++
		//nachfilter
		void Check_pseudoCheckedChanged(object sender, EventArgs e)
		{
			if (check_pseudo.Checked) 
			{
				tab_funktionen.TabPages.Add(tabPage_pseudo);
			} else
			{
				tab_funktionen.TabPages.Remove(tabPage_pseudo);
			}
		}
		void Scroll_spanScroll(object sender, ScrollEventArgs e)
		{	
			//offset darf nicht größer als span sein
			scroll_offset.Maximum = scroll_span.Value;
			scroll_offset.Minimum = 0 - scroll_span.Value;
			//span ins label schreiben
			label_span.Text = scroll_span.Value.ToString();
			label_offset.Text = scroll_offset.Value.ToString();
			switch (combo_palette.SelectedIndex) 
			{
				case 0: //grayscale
					draw_dual_palette(Color.Black,Color.White);
					break;
				case 1: //sinus rainbow
					draw_sin_rainbow_palette();
					break;
				case 2: //grad rainbow
					draw_rainbow_palette();
					break;
				case 3: //grad ironbow
					draw_ironbow_palette();
					break;
			}
		}
		void Scroll_offsetScroll(object sender, ScrollEventArgs e)
		{	
			//offset ins label schreiben
			label_offset.Text = scroll_offset.Value.ToString();
			switch (combo_palette.SelectedIndex) 
			{
				case 0: //grayscale
					draw_dual_palette(Color.Black,Color.White);
					break;
				case 1: //sinus rainbow
					draw_sin_rainbow_palette();
					break;
				case 2: //grad rainbow
					draw_rainbow_palette();
					break;
				case 3: //grad ironbow
					draw_ironbow_palette();
					break;
			}
		}
		void Combo_paletteSelectedIndexChanged(object sender, EventArgs e)
		{
			switch (combo_palette.SelectedIndex) 
			{
				case 0: //grayscale
					draw_dual_palette(Color.Black,Color.White);
					break;
				case 1: //sinus rainbow
					draw_sin_rainbow_palette();
					break;
				case 2: //grad rainbow
					draw_rainbow_palette();
					break;
				case 3: //grad ironbow
					draw_ironbow_palette();
					break;
			}
		}
		//#####################################################
		//bilder
		#endregion
		
		#region Image_Processing
        void ImageProcessing()
        {	
        	try 
        	{
	        	working = true;
	        	//initialisieren
	        	Bitmap img = (Bitmap)pic_backbox.Image.Clone();
	        	int messlengh = img.Width-(int)ML.num_messline_start.Value-(int)ML.num_messline_end.Value;
	        	//messstreifen erfassen
	        	Crop CR1 = new Crop(new Rectangle((int)ML.num_messline_start.Value, (int)ML.scroll_Messline.Value, messlengh, 3));
	        	Bitmap s_img = CR1.Apply(img);
	        	
	        	filter(ref s_img);
	        	
	        	//####################################################
	        	if (set_messline) 
	        	{ //festlegen der linie von der die farbwerte genommen werden
	        		Graphics g1 = Graphics.FromImage(img);
		        	Pen p1 = new Pen(Color.White, 3);
		        	g1.DrawLine(p1,(int)ML.num_messline_start.Value,(float)ML.scroll_Messline.Value-1,ML.Picbox1.Image.Width-(int)ML.num_messline_end.Value,(float)ML.scroll_Messline.Value-1);
	        		ML.Picbox1.Image = img;
	        	}
	        	//####################################################
	        	//filter auf zuschnitt anwenden und linien Zeichnen
        		UnsafeBitmap u_img = new UnsafeBitmap(s_img);
	        	u_img.LockBitmap();
	        	int modus = TCB_gra_modus.SelectedIndex;
	        	int blue_offset = messlengh;
	        	int math_art = TCB_math_art.SelectedIndex;
	        	bool math_mess_1 = false;
	        	bool math_mess_2 = false;
	        	bool sin_max255 = ML.check_sin_stop255.Checked;
	        	double sin_Y = 0;
	        	double sin_X = 0;
	        	double sin_pix = 0;
	        	double sin_nm = 0;
	        	if (ML.check_IR_Blue.Checked) 
	        	{
	        		blue_offset = (int)ML.num_skala_Blue_iroffset.Value;
	        	}
	        	PointPairList list = new PointPairList();
	        	PointPairList PPL_calc_1 = new PointPairList();
	        	PointPairList PPL_calc_2 = new PointPairList();
	        	if (math_active) {
	        		int index = TCB_math_op1.SelectedIndex;
	        		if (index == 0) {
	        			math_mess_1 = true;
	        		} else {
		        		if (Curves[index] != null) {
			        		PPL_calc_1 = zedGraphControl1.GraphPane.CurveList[index].Points as PointPairList;
		        		} else {
		        			math_active = false;
		        			tbtn_math_active.ForeColor = Color.Black;
		        		}
	        		}
		        	index = TCB_math_op2.SelectedIndex;
		        	if (index == 0) {
	        			math_mess_2 = true;
	        		} else {
		        		if (Curves[index] != null) {
			        		PPL_calc_2 = zedGraphControl1.GraphPane.CurveList[index].Points as PointPairList;
		        		} else {
		        			math_active = false;
		        			tbtn_math_active.ForeColor = Color.Black;
		        		}
	        		}
	        	}
	        	//this.Text = list.Capacity.ToString()+" "+PPL_calc_1.Capacity.ToString()+" "+PPL_calc_2.Capacity.ToString();
	        	if (modus == 6) { //testsinus
	        		sin_Y = (double)ML.num_sin_offY.Value;
	        		sin_X = (double)ML.num_sin_offX.Value;
	        		sin_pix = (double)ML.num_sin_pixel.Value;
	        		sin_nm = (double)ML.num_sin_nm.Value;
	        	}
	        	for (int i = 0; i < messlengh; i++ ) 
	      		{
		        	double x = ((double)i * (double)ML.num_skala_span.Value)+(double)ML.num_skala_offset.Value;
		        	double y = 0;
		        	switch (modus)
		        	{
		        		case 0:
		        			double y_mittel = 0;
		        			double y_max = 0;
		        			if (i < blue_offset) {
				        		y_mittel = ((double)u_img.GetPixel(i,1).red+(double)u_img.GetPixel(i,1).green+(double)u_img.GetPixel(i,1).blue) / 3;
				        		double max = Math.Max((double)u_img.GetPixel(i,1).red,(double)u_img.GetPixel(i,1).green);
	        					y_max = Math.Max(max,(double)u_img.GetPixel(i,1).blue);
		        			} else {
				        		y_mittel = ((double)u_img.GetPixel(i,1).red+(double)u_img.GetPixel(i,1).green) / 2;
				        		y_max = Math.Max((double)u_img.GetPixel(i,1).red,(double)u_img.GetPixel(i,1).green);
				        	}
				        	y = (y_mittel+y_max)/2; break;
		        		case 1:
		        			if (i < blue_offset) {
				        		double max = Math.Max((double)u_img.GetPixel(i,1).red,(double)u_img.GetPixel(i,1).green);
	        					y = Math.Max(max,(double)u_img.GetPixel(i,1).blue);
				        	} else {
				        		y = Math.Max((double)u_img.GetPixel(i,1).red,(double)u_img.GetPixel(i,1).green);
				        	} break;
		        		case 2:
		        			if (i < blue_offset) {
				        		y = ((double)u_img.GetPixel(i,1).red+(double)u_img.GetPixel(i,1).green+(double)u_img.GetPixel(i,1).blue) / 3;
				        	} else {
				        		y = ((double)u_img.GetPixel(i,1).red+(double)u_img.GetPixel(i,1).green) / 2;
				        	} break;
		        		case 3:
				        	y = (double)u_img.GetPixel(i,1).red; break;
		        		case 4:
		        			y = (double)u_img.GetPixel(i,1).green; break;
		        		case 5:
		        			if (i < blue_offset) {
				        		y = (double)u_img.GetPixel(i,1).blue;
				        	} else {
				        		y = (double)u_img.GetPixel(i,1).green;
				        	} break;
		        		case 6:
		        			y = Math.Sin( ((double)i-sin_Y) * Math.PI / sin_nm ) * sin_pix;
				        	y += sin_X;
					        if (sin_max255) {
			        			if (y > 255) {
			        				y = 255;
			        			}
			        		} break;
		        	} //switch (modus)
		          	if (math_active) {
		        		double y_1 = 0;
		        		if (math_mess_1) {
		        			y_1 = y;
		        		} else {
		        			y_1 = PPL_calc_1[i].Y;
		        		}
		        		double y_2 = 0;
		        		if (math_mess_2) {
		        			y_2 = y;
		        		} else {
		        			y_2 = PPL_calc_2[i].Y;
		        		}
		        		switch (math_art) {
		        			case 0: //+
		        				y = y_1 + y_2;
		        				break;
		        			case 1: //-
		        				y = y_1 - y_2;
		        				break;
		        			case 2: //*
		        				y = y_1 * y_2;
		        				break;
		        			case 3: // /
		        				y = y_1 / y_2;
		        				break;
		        		}
		        		list.Add( x, y);
		        	} else {
		        		list.Add( x, y);
		        	}
	      		} //for (int i = 0; i < messlengh; i++ )
//	        	this.Text = list.Capacity.ToString()+" "+PPL_calc_1.Capacity.ToString()+" "+PPL_calc_2.Capacity.ToString();
	        	GraphPane GP = zedGraphControl1.GraphPane;
	        	zedGraphControl1.GraphPane.CurveList[0].Label.IsVisible = graph_label;
				PointPairList PPL = zedGraphControl1.GraphPane.CurveList[0].Points as PointPairList;
				Curves[0].Color = txt_gra_linecolor.BackColor;
				Curves[0].Symbol.Type = sym;
				Curves[0].Symbol.Fill = new Fill( Color.White );
				PPL.Clear();
				PPL.Add(list);
				if (graph_merke) {
					if (Curves[TCB_merk_channel.SelectedIndex+1] != null) {
						Curves[TCB_merk_channel.SelectedIndex+1].Label.IsVisible = false;
						Curves[TCB_merk_channel.SelectedIndex+1].Clear();
					}
					Curves[TCB_merk_channel.SelectedIndex+1] = GP.AddCurve( txt_merk_name.Text,list, txt_merk_linecolor.BackColor, sym_M );
					graph_merke = false;
					Tbtn_merk_LinieMerken.ForeColor = Color.Black;
				}
				if (graph_rainbow) {
					if (IRfarbverlauf) {
						Color[] Col = new Color[]{Color.Indigo,Color.BlueViolet,Color.Blue,Color.Cyan,
						Color.Lime,Color.Yellow,Color.Red,Color.Crimson,Color.Brown,Color.Gainsboro,
						Color.Gainsboro,Color.DimGray,Color.DimGray,Color.DimGray};
						Curves[0].Line.Fill = new Fill( Col );
					} else {
						Color[] Col = new Color[]{Color.DarkBlue,Color.Blue,Color.Cyan,
						Color.Lime,Color.Yellow,Color.Red,Color.Crimson};
						Curves[0].Line.Fill = new Fill( Col );
					}
					
				} else {
					Curves[0].Line.Fill.IsVisible = false;
				}
	        	zedGraphControl1.AxisChange();
				zedGraphControl1.Invalidate();
        		u_img.UnlockBitmap();
	        	//####################################################
	        	//nachfilter
	        	ML.Picbox1.Image = img;
	        	u_img.Dispose();
        		s_img.Dispose();
//        		img.Dispose();
	        	working = false;
	        	info_err.Visible = false;
        	} 
        	catch (Exception err) 
        	{
        		info_err.Visible = true;
        		info_err.Text = "Fehler in (ImageProcessing):"+error_s+Environment.NewLine+err.Message;
        		working = false;
        	}
        }
        void filter(ref Bitmap img)
        {
        	//##########################################################
        	//filter 1
        	
        	if (check_invert.Checked)
        	{	//ein normaler invertierer
        		Invert f_inv = new Invert();
        		img = f_inv.Apply(img);
        	}
        	if (check_add.Checked) 
        	{
        		Add f_add = new Add((Bitmap)img.Clone());
        		img = f_add.Apply(img);
        	}
        	if (check_contrast.Checked) 
        	{
        		ContrastCorrection contrast = new ContrastCorrection();
        		contrast.Factor = (double)scroll_contrast.Value / 1000;
				contrast.ApplyInPlace(img);
				BrightnessCorrection bright = new BrightnessCorrection();
				bright.AdjustValue = (double)scroll_helligkeit.Value / 1000;
				bright.ApplyInPlace( img );
        	}
        	if (check_minmax.Checked) 
        	{
        		if (radio_max.Checked) 
        		{
        			Merge mer = new Merge( (Bitmap)pic_backfilter.Image );
					img = mer.Apply( img );
        		}
        		if (radio_min.Checked) 
        		{
        			Intersect inter = new Intersect( (Bitmap)pic_backfilter.Image );
					img = inter.Apply( img );
        		}
        	}
        	//##########################################################
        	//filter 2
		    if (check_colorF.Checked)
			{	//filtert rgb pixel (weiß = r&g&b)
		    	ColorFiltering f_col = new ColorFiltering();
		    	f_col.Red = new IntRange((int)num_col_r2.Value, (int)num_col_r.Value);
		        f_col.Green = new IntRange((int)num_col_g2.Value, (int)num_col_g.Value);
		        f_col.Blue = new IntRange((int)num_col_b2.Value, (int)num_col_b.Value);
		        img = f_col.Apply(img);
			}
			if (check_channelF.Checked)
			{	//filtert rgb von den pixeln (weiß und rot sind nach dem filtern
				//von blau und grün >beide< rot)
		    	ChannelFiltering f_chan = new ChannelFiltering();
		    	f_chan.Red = new IntRange((int)num_chan_r2.Value, (int)num_chan_r.Value);
		        f_chan.Green = new IntRange((int)num_chan_g2.Value, (int)num_chan_g.Value);
		        f_chan.Blue = new IntRange((int)num_chan_b2.Value, (int)num_chan_b.Value);
		        img = f_chan.Apply(img);
			}
			if (check_euclideancolorF.Checked) 
			{	//wieder irgend ein farbfilter
				EuclideanColorFiltering ec = new EuclideanColorFiltering( );
				ec.CenterColor = new RGB((byte)num_ec_r.Value, (byte)num_ec_g.Value, (byte)num_ec_b.Value );
        		ec.Radius = (short)num_ec_radius.Value;
				img = ec.Apply(img);
			}
			if (check_pseudo.Checked)
        	{
        		do_main_pseudocolor(ref img);
        	}
        	pic_backfilter.Image = (Bitmap) img.Clone();
        }
        
        void draw_dual_palette(Color startfarbe,Color endfarbe)
		{	//erzeuge einen Farbverlauf und eine dementsprechende farbtabelle
			
			//erstelle ein Bild mit 256 Pixeln, Farbwerte sind von 0-255 (byte)
			//also braucht man 1-256 Pixel zum auswerten
			pic_palette.Image = new Bitmap(256, pic_palette.Height);
			//Grafikobjekte erstellen
			Graphics G = Graphics.FromImage(pic_palette.Image);
			Rectangle rect = new Rectangle(0, 0, pic_palette.Image.Width, pic_palette.Image.Height);
			LinearGradientBrush GB = new LinearGradientBrush(rect, startfarbe, endfarbe, LinearGradientMode.Horizontal);
			//fülle das rechteck mit den übergebenen farben
			G.FillRectangle(GB, rect);
			
			//neue farbtabelle erstellen
			Bitmap img = (Bitmap)pic_palette.Image;
			Color col = new Color();
			for (int i = 0; i < 256; i++ ) 
			{
				col = img.GetPixel(i,1);
				map_r[i] = col.R;
				map_g[i] = col.G;
				map_b[i] = col.B;
			}
		}
		void draw_rainbow_palette()
		{	//erzeuge einen Farbverlauf und eine dementsprechende farbtabelle
			
			//erstelle ein Bild mit 256 Pixeln, Farbwerte sind von 0-255 (byte)
			//also braucht man 1-256 Pixel zum auswerten
			pic_palette.Image = new Bitmap(256, pic_palette.Height);
			//Grafikobjekte erstellen
			Graphics G = Graphics.FromImage(pic_palette.Image);
			Rectangle rect = new Rectangle(0, 0, pic_palette.Image.Width, pic_palette.Image.Height);
			LinearGradientBrush GB = new LinearGradientBrush(rect, Color.Red, Color.Blue, LinearGradientMode.Horizontal);
			//start und endfarbe mit neuen überschreiben
			ColorBlend CB = new ColorBlend();
			CB.Colors = new Color[]
			{
				Color.Black,
				Color.Black,
            	Color.DarkBlue,
            	Color.DodgerBlue,
            	Color.LimeGreen,
            	Color.Yellow,
            	Color.Gold,
            	Color.Red,
            	Color.White,
            	Color.White
			};
			//punkte festlegen, an denen die farben sein sollen, was dazwischen liegt
			//wird zum farbverlauf
      		float[] CP = new float[10];
      		//anfags und endpunkte müssen festliegen, 
      		//deshalb sind die anfangs und endfarben auch zweimal vorhanden
      		CP[0] = 0.0f;
      		CP[9] = 1.0f;
      		float span = (float) (((float)scroll_span.Value - 7f) / 10f)*3;
      		float offset = (float) (((float)scroll_offset.Value) / 12f)*3;
      		for (float i = 1; i < 9; i++ ) 
      		{	
      			CP[(int)i] = (float)( (i + (span*0.75) + offset) / ((span*1.5) + 9) );
      		}
      			
      		//werte übergeben
      		CB.Positions = CP;
			GB.InterpolationColors = CB;
			
			//fülle das rechteck mit den übergebenen farben
			G.FillRectangle(GB, rect);
			
			//neue farbtabelle erstellen
			Bitmap img = (Bitmap)pic_palette.Image;
			Color col = new Color();
			for (int i = 0; i < 256; i++ ) 
			{
				col = img.GetPixel(i,1);
				map_r[i] = col.R;
				map_g[i] = col.G;
				map_b[i] = col.B;
			}
		}
		void draw_ironbow_palette()
		{	//erzeuge einen Farbverlauf und eine dementsprechende farbtabelle
			
			//erstelle ein Bild mit 256 Pixeln, Farbwerte sind von 0-255 (byte)
			//also braucht man 1-256 Pixel zum auswerten
			pic_palette.Image = new Bitmap(256, pic_palette.Height);
			//Grafikobjekte erstellen
			Graphics G = Graphics.FromImage(pic_palette.Image);
			Rectangle rect = new Rectangle(0, 0, pic_palette.Image.Width, pic_palette.Image.Height);
			LinearGradientBrush GB = new LinearGradientBrush(rect, Color.Red, Color.Blue, LinearGradientMode.Horizontal);
			//start und endfarbe mit neuen überschreiben
			ColorBlend CB = new ColorBlend();
			CB.Colors = new Color[]
			{
				Color.Black,
				Color.Black,
            	Color.Blue,
            	Color.DarkViolet,
            	Color.Crimson,
            	Color.Orange,
            	Color.Yellow,
            	Color.White,
            	Color.White
			};
			//punkte festlegen, an denen die farben sein sollen, was dazwischen liegt
			//wird zum farbverlauf
      		float[] CP = new float[9];
      		//anfags und endpunkte müssen festliegen, 
      		//deshalb sind die anfangs und endfarben auch zweimal vorhanden
      		CP[0] = 0.0f;
      		CP[8] = 1.0f;
      		float span = (float) ( ((float)scroll_span.Value - 7f) / 10f)*3;
      		float offset = (float) ( (float)scroll_offset.Value / 12f)*3;
      		for (float i = 1; i < 8; i++ ) 
      		{	
      			CP[(int)i] = (float)( (i + (span*0.75) + offset) / ((span*1.5) + 8) );
      		}
      			
      		//werte übergeben
      		CB.Positions = CP;
			GB.InterpolationColors = CB;
			
			//fülle das rechteck mit den übergebenen farben
			G.FillRectangle(GB, rect);
			
			//neue farbtabelle erstellen
			Bitmap img = (Bitmap)pic_palette.Image;
			Color col = new Color();
			for (int i = 0; i < 256; i++ ) 
			{
				col = img.GetPixel(i,1);
				map_r[i] = col.R;
				map_g[i] = col.G;
				map_b[i] = col.B;
			}
		}
		void draw_sin_rainbow_palette()
		{
			//neue graustufen farbpalette
        	draw_dual_palette(Color.Black,Color.White);
        	
			//variablen erstellen
			int span = scroll_span.Value;
			int offset = scroll_offset.Value;
			int colspan = 270 - (span * 2);
			
			//Palette von 0-255 durchlaufen
        	for ( int i = 0; i < 256; i++ )
			{
				if (i < (span + offset)) 
				{	//schwarz am Anfang
					map_r[i] = 0;
					map_g[i] = 0;
					map_b[i] = 0;
				} else if (i < (256 - (span - offset)))
				{
					// Neue Farbe [-1,1]:
					double red = Math.Sin( (i - span - offset) * 2 * Math.PI / colspan - Math.PI);
					double green = Math.Sin( (i - span - offset) * 2 * Math.PI / colspan - Math.PI / 2);
					double blue = Math.Sin( (i - span - offset) * 2 * Math.PI / colspan);
			
					// Neue Farbe [0,255]:
					red = (red + 1) * 0.5 * 255;
					green = (green + 1) * 0.5 * 255;
					blue = (blue + 1) * 0.5 * 255;
					
					map_r[i] = (byte)red;
				    map_g[i] = (byte)green;
				    map_b[i] = (byte)blue;
				} else
				{	//weiß am Ende
					map_r[i] = 255;
					map_g[i] = 255;
					map_b[i] = 255;
				}
			}
        	Bitmap img = (Bitmap)pic_palette.Image.Clone();
       		ColorRemapping filter2 = new ColorRemapping( map_r, map_g, map_b );
        	pic_palette.Image = filter2.Apply(img);
		}
		void do_main_pseudocolor(ref Bitmap img)
        {
			//Bild (sicherheitshalber) in graustufen umwandeln
        	//IFilter grayscale = new Grayscale( 0.2125, 0.7154, 0.0721 );
        	IFilter grayscale = new Grayscale( 0.33, 0.33, 0.33 );
            Bitmap tmp = grayscale.Apply(img);
            
			//Bild von graustufen auf RGB setzten
			//es ändert sich äußerlich nicht, hat aber eine andere Farbscala
            GrayscaleToRGB filter1 = new GrayscaleToRGB();
			img = filter1.Apply(tmp);
			
			if (combo_palette.SelectedIndex == 0) 
            {
            	return;
            }
			
			//Bildfarben aus der "byte color map" neu verteilen
			ColorRemapping filter2 = new ColorRemapping( map_r, map_g, map_b );
			filter2.ApplyInPlace(img);
        }
		
		void video_NewFrame(object sender, NewFrameEventArgs eventArgs)
        {	
			Bitmap image = (Bitmap)eventArgs.Frame.Clone();
			pic_backbox.Image = image;
        }
		void Timer_offTick(object sender, EventArgs e)
		{
			if (working) 
			{
				if (cam < 10) 
				{
					cam++;
					return;
				}
				draw_sin_rainbow_palette();
				working = false;
			}
			cam = 0;
			ImageProcessing();
		}
		void Timer_onTick(object sender, EventArgs e)
		{
			if (working)
			{
				if (cam < 10) 
				{
					cam++;
					return;
				}
				draw_sin_rainbow_palette();
				working = false;
			}
			cam = 0;
			ImageProcessing();
		}
		#endregion
		
		void xxx ()
		{
			
		}
		//##################################################################
		
		
		
		
		
	}
}
